/*
 * Main.java
 *
 * Created on 2006-04-08T10:40+02:00
 */

package cz.muni.fi.pb138.xslttransformer;

import java.io.File;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

/**
 * Jednoducha spustitelna trida provadejici XSLT transformaci na zvolenem
 * vstupnim XML souboru podle zadaneho XSL stylu.
 *
 * @author Michal Ruzicka
 *         &lt;<a href="mailto:xruzick7@fi.muni.cz">xruzick7@fi.muni.cz</a>&gt;
 * @version 1.0.1, 2006-04-10
 */
public class Main {
    
    /**
     * Metoda overi spravnost argumentu predanych z prikazoveho radku a na
     * uvedenem souboru provede XSLT transformaci podle zvoleneho XSL stylu.
     * Vystup je ulozen do zvoleneho souboru nebo do souboru out.xml
     * v aktualnim adresari.
     *
     * @param args parametry z prikazoveho radku;<br/>
     *             1. argument je povinny a predstavuje cestu ke vstupnimu XML
     *             souboru,<br/>
     *             2. argument je povinny a predstavuje cestu k XSL stylu,<br/>
     *             3. argument je volitelny a predstavuje cestu k vystupnimu
     *             souboru
     */
    public static void main(String[] args) {
        
        if (!((args.length == 2) || (args.length == 3))) {
            System.err.println("Nespravny pocet argumentu prikazoveho radku.");
            System.err.println("Pouziti: java -jar XSLTTransformer.jar " +
                    "vstup.xml XSLTstyl.xsl [vystup.xml]\n");
            System.err.println("Pokud nebude uveden vystupni soubor, vystup " +
                    "bude zapsan do souboru out.xml v aktualnim adresari.");
            System.exit(1);
        }
        
        StreamSource inputFile = new StreamSource(new File(args[0]));
        StreamSource xsltStyleFile = new StreamSource(new File(args[1]));
        StreamResult outputFile;
        if (args.length == 2) {
            outputFile = new StreamResult(new File("./out.xml"));
        } else {
            outputFile = new StreamResult(new File(args[2]));
        }
        
        TransformerFactory transformerFactory = 
                TransformerFactory.newInstance();
        try {
            Transformer xsltTransformer = 
                    transformerFactory.newTransformer(xsltStyleFile);
            xsltTransformer.transform(inputFile, outputFile);
        } catch (TransformerConfigurationException ex) {
            System.err.println("Vyskytly se chyby pri analyze XSLT stylu, " +
                    "nebo se nepodarilo vytvorit instanci transformatoru.\n");
            ex.printStackTrace();
            System.exit(2);
        } catch (TransformerException ex) {
            System.err.println("Pri transformaci se vyskytly chyby.\n");
            ex.printStackTrace();
            System.exit(3);
        }
        
        System.exit(0);
        
    }
    
}
