﻿/*
    Program ukazující práci s databází SQL.

    Pozor: Je nutné nainstalovat NuGet package System.Data.SqlClient
*/

using System;
using System.Data.SqlClient;
using System.IO;

namespace SQLDemo
{
    class Program
    {
        private const string FileName = "Lide.txt";

        static public void Connect(string s)
        {
            using (SqlConnection sCon = new SqlConnection(s))
            {
                sCon.Open();

                Console.WriteLine("Parametry připojení:");
                Console.WriteLine("Databáze     : " + sCon.Database);
                Console.WriteLine("Zdroj dat    : " + sCon.DataSource);
                Console.WriteLine("Verze serveru: " + sCon.ServerVersion);
                Console.WriteLine("Stav spojení : " + sCon.State);
                Console.WriteLine("Stanice      : " + sCon.WorkstationId);
                Console.WriteLine();
            }
        }

        static public void InsertValues(string s)
        {
            string line;
            string[] values = new string[4];

            using (SqlConnection sCon = new SqlConnection(s))
            {
                sCon.Open();

                SqlCommand sCmd = new SqlCommand();

                sCmd.Connection = sCon;
                sCmd.CommandText = "INSERT INTO dbo.Lide(Jmeno, Prijmeni, Vek, Plat)"
                    + "VALUES (@jmeno, @prijmeni, @vek, @plat)";

                using (StreamReader sr = new StreamReader(FileName))
                {
                    while ((line = sr.ReadLine()) != null)
                    {
                        values = line.Split(new char[] { ',', ',', ',' });

                        sCmd.Parameters.Clear();
                        sCmd.Parameters.AddWithValue("@jmeno", values[0]);
                        sCmd.Parameters.AddWithValue("@prijmeni", values[1]);
                        sCmd.Parameters.AddWithValue("@vek", values[2]);
                        sCmd.Parameters.AddWithValue("@plat", values[3]);
                        sCmd.ExecuteNonQuery();
                    }
                }
            }
        }

        static public void Query(string s)
        {
            using (SqlConnection sCon = new SqlConnection(s))
            {
                sCon.Open();

                SqlCommand sCmd = new SqlCommand
                   ("SELECT Jmeno, Prijmeni FROM dbo.Lide WHERE Vek>35", sCon);

                Console.WriteLine("Jména a příjmení osob starších než 35 let");
                Console.WriteLine();

                SqlDataReader sr = sCmd.ExecuteReader();
                while (sr.Read())
                {
                    //Console.WriteLine("{0}, {1}", sr[0], sr[1]);
                    Console.WriteLine("{0}, {1}", sr["Jmeno"], sr["Prijmeni"]);
                }
                sr.Close();

                Console.WriteLine();
            }
        }

        static public void Count(string s)
        {
            int count;

            using (SqlConnection sCon = new SqlConnection(s))
            {
                sCon.Open();

                SqlCommand sCmd = new SqlCommand
                   ("SELECT COUNT (*) FROM dbo.Lide WHERE Vek>35", sCon);
                count = (int)sCmd.ExecuteScalar();

                Console.WriteLine("Počet osob starších než 35 let: {0}", count);
                Console.WriteLine();
            }
        }

        static void DeleteValues(string s)
        {
            using (SqlConnection sCon = new SqlConnection(s))
            {
                sCon.Open();

                SqlCommand sCmd = new SqlCommand
                   ("DELETE FROM dbo.Lide", sCon);

                sCmd.ExecuteNonQuery();
            }
        }

        static void Main(string[] args)
        {
            string conString = "Data Source=(LocalDB)\\MSSQLLocalDB;" +
                "AttachDbFilename=" + Directory.GetCurrentDirectory() +
               "\\MyDB.mdf;Integrated Security=True";

            Connect(conString);

            InsertValues(conString);

            Query(conString);

            Count(conString);

            DeleteValues(conString);
        }
    }
}

