﻿/*
     Program ukazujici pouzíti regularnich vyrazu. 
*/

using System;
using System.Text.RegularExpressions;
using System.IO;

namespace RegularExp
{
    class Program
    {

        const string fName = "Konference.txt";

        static public void WriteEmails(string txt)
        {
            Regex rExp = new Regex(@"[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}");
            MatchCollection match = rExp.Matches(txt);
            Console.WriteLine("E-mailové adresy:");
            Console.WriteLine("-----------------");
            foreach (Match m in match)
                Console.WriteLine(m.Value);
            Console.WriteLine();
        }

        static public void WritePhoneNumbers(string txt)
        {
            Regex rExp = new Regex(@"[+]?[()/0-9 -]{9,}");
            Match match = rExp.Match(txt);

            Console.WriteLine("Telefonní čísla:");
            Console.WriteLine("----------------");
            while (match.Success)
            {
                Console.WriteLine(match.Value);
                match = match.NextMatch();
            }
            Console.WriteLine();
        }

        static void Main(string[] args)
        {
            string text;

            using (StreamReader sr = new StreamReader(fName))
            {
                text = sr.ReadToEnd();
            }
            WriteEmails(text);
            WritePhoneNumbers(text);
        }
    }
}

