﻿/*
    Program ukazující serializaci pomocí třídy JsonConvert.
*/

using System;
using Newtonsoft.Json;

namespace JSONSerialization2
{
    class Product
    {
        public string Name { get; set; }
        public DateTime ExpiryDate { get; set; }
        public decimal Price { get; set; }
        public string[] Sizes { get; set; }
    }

    class Program
    {
        static void Main(string[] args)
        {
            Product product = new Product();

            product.Name = "Apple";
            product.ExpiryDate = new DateTime(2008, 12, 28);
            product.Price = 10;
            product.Sizes = new string[] { "Small", "Medium", "Large" };

            string output = JsonConvert.SerializeObject(product);

            Console.WriteLine("Serializovaný objekt v JSON:");
            Console.WriteLine("----------------------------");
            Console.WriteLine(output);
            Console.WriteLine();

            Product dProduct = JsonConvert.DeserializeObject<Product>(output);

            Console.WriteLine("Deserializovaný objekt:");
            Console.WriteLine("-----------------------");
            Console.WriteLine(dProduct.Name);
            Console.WriteLine(dProduct.ExpiryDate.ToShortDateString());
            Console.WriteLine(dProduct.Price);
            Console.Write("Sizes: ");
            foreach (string s in dProduct.Sizes)
            {
                Console.Write(s + " ");
            }
            Console.WriteLine();
        }
    }
}

