﻿/*
    Program ukládající do textového souboru soubory, které se
    nacházejí v zadaném adresáři.
*/

using System;
using System.IO;

namespace Files
{
    class Program
    {
        private const string dirName = "C:\\Windows";
        private const string fName = "Files.txt";

        static void Main(string[] args)
        {
            DirectoryInfo dirInfo = new DirectoryInfo(dirName);
            FileInfo[] files = dirInfo.GetFiles();
            string line;

            using (StreamWriter sw = new StreamWriter(fName))
            {
                foreach (FileInfo file in files)
                    sw.WriteLine("{0,-40}{1,8}", file.Name, file.Length);
            }

            using (StreamReader sr = new StreamReader(fName))
            {
                while ((line = sr.ReadLine()) != null)
                    Console.WriteLine(line);
            }
        }
    }
}


