﻿/*
    Program ukazující serializaci pomocí třídy DataContractSerializer.
*/

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;
using System.Xml;

namespace DataContractSerialization
{
    [DataContract]
    public class User
    {
        [DataMember]
        public string FirstName { get; set; }
        [DataMember]
        public string LastName { get; set; }
        [DataMember]
        public DateTime Born { get; set; }

        public override string ToString()
        {
            return FirstName + " " + LastName + ", narozen: " +
                   Born.Day + ". " + Born.Month + ". " + Born.Year;
        }
    }

    class Program
    {
        private static List<User> users;

        public static void Serialize()
        {
            DataContractSerializer dcSerializer =
                new DataContractSerializer(typeof(List<User>));

            using (XmlTextWriter xw =
                new XmlTextWriter("Users.xml", Encoding.UTF8))
            {
                dcSerializer.WriteObject(xw, users);
            }
        }

        public static void Deserialize()
        {
            DataContractSerializer dcSerializer =
                new DataContractSerializer(users.GetType());

            using (XmlTextReader xr = new XmlTextReader("Users.xml"))
            {
                users = (List<User>)dcSerializer.ReadObject(xr);
            }
        }

        public static void WriteUsers()
        {
            Console.WriteLine("Seznam uživatelů:");
            Console.WriteLine("-----------------");
            Console.WriteLine();

            foreach (User u in users)
                Console.WriteLine(u.ToString());

            Console.WriteLine();
        }

        static void Main(string[] args)
        {
            users = new List<User>
            {
               new User { FirstName = "Jan", LastName = "Novak",
                          Born = new DateTime (1990, 10, 1)
                        },
               new User { FirstName = "Pavel", LastName = "Svoboda",
                          Born = new DateTime (1995, 8, 2)
                        },
               new User { FirstName = "Michal", LastName = "Blazek",
                          Born = new DateTime (1984, 11, 5)
                        }
            };

            WriteUsers();
            Serialize();

            users.Clear();
            WriteUsers();

            Deserialize();
            WriteUsers();
        }
    }
}



