﻿/*
    Program ukazující serializaci pomocí třídy BinaryFormatter.
*/

using System;
using System.Collections.Generic;
using System.Runtime.Serialization.Formatters.Binary;
using System.IO;

namespace BinarySerialization
{
    [Serializable]
    class User
    {
        public string FirstName { get; set; }
        public string LastName { get; set; }
        public DateTime Born { get; set; }

        public override string ToString()
        {
            return FirstName + " " + LastName + ", narozen: " +
                   Born.Day + ". " + Born.Month + ". " + Born.Year;
        }
    }

    class Program
    {
        private static List<User> users;

        public static void Serialize()
        {
            BinaryFormatter binForm =
                new BinaryFormatter();

            using (FileStream fs = new FileStream("Users.dat", FileMode.Create))
            {
                binForm.Serialize(fs, users);
            }
        }

        public static void Deserialize()
        {
            BinaryFormatter binForm =
                new BinaryFormatter();

            using (FileStream fs = new FileStream("Users.dat", FileMode.Open))
            {
                users = (List<User>)binForm.Deserialize(fs);
            }
        }

        public static void WriteUsers()
        {
            Console.WriteLine("Seznam uživatelů:");
            Console.WriteLine("-----------------");
            Console.WriteLine();

            foreach (User u in users)
                Console.WriteLine(u.ToString());

            Console.WriteLine();
        }

        static void Main(string[] args)
        {
            users = new List<User>
            {
               new User { FirstName = "Jan", LastName = "Novak",
                          Born = new DateTime (1990, 10, 1)
                        },
               new User { FirstName = "Pavel", LastName = "Svoboda",
                          Born = new DateTime (1995, 8, 2)
                        },
               new User { FirstName = "Michal", LastName = "Blazek",
                          Born = new DateTime (1984, 11, 5)
                        }
            };

            WriteUsers();
            Serialize();

            users.Clear();
            WriteUsers();

            Deserialize();
            WriteUsers();
        }
    }
}
