/*
    Program, ktery upravuje delku radku vstupniho textoveho souboru
    a vysledek zapisuje do vystupniho textoveho souboru.

    Vstupni textovy soubor je clenen do slov (posloupnosti znaku
    neobsahujicich mezeru ani oddelovac radku (znak konce radku),
    konecne i nulove delky), ktera jsou oddelena mezerou nebo znakem
    konce radku.

    Vystupni textovy soubor obsahuje vsechna slova vstupniho textu.
    Slova se nesmi rozdelovat, musi byt oddelena mezerou nebo znakem
    konce radku tak, aby delka radku vystupniho souboru byla mensi nebo
    rovna dane konstante LMAX.
*/

#include <stdio.h>
#include <string.h>

#define LMAX 30
#define SMAX 15

unsigned short ctiSlovo(FILE *f, char *s)
{
    fscanf(f,"%s",s);
    return strlen(s);
}

int main(void)
{
    FILE *vstup, *vystup;
    unsigned short delkaRadku,delkaSlova;
    char slovo[SMAX+1];

    puts("Program pro upravu delky radku textoveho souboru");

    vstup=fopen("vstup.txt","r");
    vystup=fopen("vystup.txt","w");

    delkaRadku=0;
    delkaSlova=ctiSlovo(vstup,slovo);
    fputs(slovo,vystup);
    delkaRadku+=delkaSlova;

    while(!feof(vstup))
    {
      delkaSlova=ctiSlovo(vstup,slovo);
      if (delkaRadku+delkaSlova<LMAX)
         {
           fputc(' ',vystup);
           delkaRadku++;
         }
         else
         {
           fputc('\n',vystup);
           delkaRadku=0;
         }
      fputs(slovo,vystup);
      delkaRadku+=delkaSlova;
    }
    fputc('\n',vystup);

    fclose(vystup);
    fclose(vstup);

    puts("Uprava byla uspesne provedena");

    return 0;
}
