% -*- latex -*-
% $Id: amsmath.plt,v 2.25 2008/11/12 09:43:55 grimm Exp $
\ProvidesPackage{amsmath}[2008/11/10 v1.3 AMS math features for Tralics]


\DeclareOption{leqno}{\XMLaddatt[1]{equation-number}{left}}
\DeclareOption{reqno}{\XMLaddatt[1]{equation-number}{right}}
\DeclareOption{fleqn}{\XMLaddatt[1]{flushed-equation}{true}}

\DeclareOption{intlimits}{\let\ilimits@\displaylimits}
\DeclareOption{nointlimits}{\let\ilimits@\nolimits}

\DeclareOption{sumlimits}{\let\slimits@\displaylimits}
\DeclareOption{nosumlimits}{\let\slimits@\nolimits}
\DeclareOption{namelimits}{\PassOptionsToPackage{namelimits}{amsopn}}
\DeclareOption{nonamelimits}{\PassOptionsToPackage{nonamelimits}{amsopn}}
\newif\ifctagsplit@
\DeclareOption{centertags}{\ctagsplit@true}
\DeclareOption{tbtags}{\ctagsplit@false}
\DeclareOption{cmex10}{}
\DeclareOption{?}{}
\ExecuteOptions{nointlimits,sumlimits,namelimits,centertags}
\ProcessOptions\par


\def\choose{\atopwithdelims()}
\def\brack{\atopwithdelims[]}
\def\brace{\atopwithdelims\{\}}
\def\shoveleft{\multicolumn{1}{l}}
\def\shoveright{\multicolumn{1}{r}}
\def\intertext#1{\multicolumn{2}{l}{\mbox{#1}}\\}
\def\mathpalette#1#2{\mathchoice {#1\displaystyle {#2}}%
{#1\textstyle {#2}}{#1\scriptstyle{#2}}{#1\scriptscriptstyle{#2}}}


\ifctagsplit@\else \XMLaddatt[1]{split-tags}{tb} \fi

% \RequirePackage{amstext}[2007/01/01]   % not needed
\RequirePackage{amsbsy}[2007/01/01]
\RequirePackage{amsopn}[2007/01/01]
\providecommand{\AmS}{AMS}
\def\Hat{\hat}
\def\Check{\check}
\def\Tilde{\tilde}
\def\Acute{\acute}
\def\Grave{\grave}
\def\Dot{\dot}
\def\Ddot{\ddot}
\def\Breve{\breve}
\def\Bar{\bar}
\def\Vec{\vec}

\def\ams@unimp{\UnimplementedOperator}
%\def\ams@unimp{\mathbox{mstyle}[color][red]{X}}

\def\Bbbk{\mathbb{k}}

\newlength\mathindent
\newskip\multlinegap
\ifx\c@equation\undefined \newcounter{equation}\fi

\newcount\c@MaxMatrixCols \c@MaxMatrixCols=10  % 

\def\DeclareMathAlphabet#1#2#3#4#5{\a@define#1}
\def\DeclareMathSymbol#1#2#3#4{\a@define#1}
\def\a@define#1{\ifdefined#1 \else\let#1\relax\fi}

\newcommand\hdotsfor[2][]{%
  \ifcase #2 \or\dots\or\dots&\dots
  \or\dots&\dots&\dots\or\dots&\dots&\dots&\dots
  \or\dots&\dots&\dots&\dots&\dots\or\dots&\dots&\dots&\dots&\dots&\dots
  \or\dots&\dots&\dots&\dots&\dots\or\dots&\dots&\dots&\dots&\dots&\dots
  \or\dots&\dots&\dots&\dots&\dots&\dots&\dots\or\dots&\dots&\dots&\dots&\dots&\dots&\dots&\dots\fi
}


%% Objects that are not yet defined but described in the Book


% Verbatim copy of the AMS math code.
% \numberwithin{equation}{section} is the same as
%    \@addtoreset{equation}{section} 
%    \def\theequation{\thesection.\arabic{equation}}
\providecommand{\numberwithin}[3][\arabic]{%
  \@ifundefined{c@#2}{\@nocounterr{#2}}{%
    \@ifundefined{c@#3}{\@nocnterr{#3}}{%
      \@addtoreset{#2}{#3}%
      \@xp\xdef\csname the#2\endcsname{%
        \@xp\@nx\csname the#3\endcsname .\@nx#1{#2}}}}%
}

% Command used by T. Bouche
% \equalenv{foo}{bar} is \let\foo\bar\let\endfoo\endbar
\providecommand\equalenv[2]{%
 \@ifundefined{#1}{\@xp\let\csname #1\@xp\endcsname\csname#2\endcsname
   \@xp\let\csname end#1\@xp\endcsname\csname end#2\endcsname}
 {\message{#1 already defined: I won't redefine it!^^J}}}

\newcommand\substack[1]{\begin{array}{c}#1\end{array}}
\newenvironment{subarray}[1]
{\bgroup\scriptstyle\begin{matrix}} {\end{matrix}\egroup}
\newenvironment{smallmatrix}{\begin{matrix}}{\end{matrix}}
\def\intertext#1{\text{\let\vspace\@gobble#1}\\}
\def\intertext#1{\multicolumn{2}{l}{\text{\let\vspace\@gobble#1}}\\}
\def\displaybreak{}

\def\qed{\ensuremath{\Box}}


%% Align envs 
\newenvironment{align}{\begin{@align}{1}{}{-1}}{\end{@align}}
\newenvironment{align*}{\begin{@align}{1}{*}{-1}}{\end{@align}}
\newenvironment{flalign}{\begin{@align}{2}{}{-1}}{\end{@align}}
\newenvironment{flalign*}{\begin{@align}{2}{*}{-1}}{\end{@align}}
\newenvironment{alignat}{\begin{@align}{0}{}}{\end{@align}}
\newenvironment{alignat*}{\begin{@align}{0}{*}}{\end{@align}}
\newenvironment{xalignat}{\begin{@align}{1}{}}{\end{@align}}
\newenvironment{xalignat*}{\begin{@align}{1}{*}}{\end{@align}}
\newenvironment{xxalignat}{\begin{@align}{2}{}}{\end{@align}}
\newenvironment{xxalignat*}{\begin{@align}{2}{*}}{\end{@align}}



\def\minalignsep{0pt}

\newenvironment{gathered}[1][c]{\begin{array}{c}}{\end{array}}


%% Tags
\newcommand{\raisetag}[1]{} % no-op

\def\@x@tag#1{\formulaattribute{tag}{(#1)}}
\def\@y@tag#1{\formulaattribute{tag}{#1}}
%\def\x@tag#1{\qquad\mathrm{(#1)}}
%\def\y@tag#1{\qquad\mathrm{#1}}

\let\o@xtag\@xtag\let\o@ytag\@ytag  % make a copy
\let\ox@tag\x@tag\let\oy@tag\y@tag  % make a copy

\def\tagasattribute{%
  \let\@xtag\o@xtag\let\@ytag\o@ytag 
  \let\x@tag\@x@tag \let\y@tag\@y@tag}

\def\tagatendofformula{  
  \let\@xtag\o@xtag\let\@ytag\o@ytag 
  \let\x@tag\ox@tag \let\y@tag\oy@tag}

\def\tagatcurpos{%
  \let\@xtag\ox@tag\let\@ytag\oy@tag 
}
\tagatendofformula



\def\sqrtsign{\sqrt}

\let\leftroot \@gobble
\let\uproot \@gobble

\let\bmdefine\def
\let\bm\mathbf
\def\boldmath{\mathversion{bold}}
\def\unboldmath{\mathversion{normal}}
\def\ibinom{\genfrac\lbrace\rbrace{0pt}{}}

\let\bignplus\ams@unimp
\let\boxbar\ams@unimp

% Table 8.13
\let\bbslash\ams@unimp
\let\fatbslash\ams@unimp
\let\fatslash\ams@unimp
\let\lbag\ams@unimp
\let\rbag\ams@unimp
\let\minuso\ams@unimp
\let\moo\ams@unimp
\let\nplus\ams@unimp
\let\Ydown\ams@unimp
\let\Yup\ams@unimp
\let\Yleft\ams@unimp
\let\Yright\ams@unimp

% table 8.15
\let\ovee\ams@unimp
\let\owedge\ams@unimp
\let\varovee\ams@unimp
\let\varowedge\ams@unimp

% Table 8.20
\let\curlyveedownarrow\ams@unimp
\let\curlyveeuparrow\ams@unimp
\let\curlywedgeuparrow\ams@unimp
\let\curlywedgedownarrow\ams@unimp
\let\nnearrow\ams@unimp
\let\nnwarrow\ams@unimp
\let\ssearrow\ams@unimp
\let\sswarrow\ams@unimp

% Table 8.22
\let\Arrownot\ams@unimp
\let\Longarrownot\ams@unimp
\let\Mapsfromchar\ams@unimp
\let\Mapstochar\ams@unimp
\let\arrownot\ams@unimp
\let\longarrownot\ams@unimp
\let\mapsfromchar\ams@unimp
\let\mapstochar\ams@unimp
\let\lhook\ams@unimp
%\let\not\ams@unimp
\let\rhook\ams@unimp

% Table 8.23
\let\smallfrown\ams@unimp
\let\smallsmile\ams@unimp
\let\varpropto\ams@unimp
\let\shortmid\ams@unimp
\let\nshortmid\ams@unimp
\let\nshortparallel\ams@unimp
\let\shortparallel\ams@unimp


% Table 8.27
\let\llceil\ams@umimp
\let\rrceil\ams@umimp
\let\Lbag\ams@umimp
\let\Rbag\ams@umimp
\let\llfloor\ams@unimp
\let\rrfloor\ams@unimp

\let\nsucceq\ams@unimp
\let\npreceq\ams@unimp
\let\Lbag\ams@unimp
\let\Rbag\ams@unimp
\let\llceil\ams@unimp
\let\rrceil\ams@unimp
\let\leftrightarroweq\ams@unimp

\let\nsupseteqq\ams@unimp
\let\nsubseteqq\ams@unimp
\let\lvertneqq\ams@unimp
\let\gvertneqq\ams@unimp
\let\ntrianglelefteqslant\ams@unimp
\let\ntrianglerighteqslant\ams@unimp
\let\trianglelefteqslant\ams@unimp
\let\trianglerighteqslant\ams@unimp
\let\subsetplus\ams@unimp
\let\subsetpluseq\ams@unimp
\let\supsetplus\ams@unimp
\let\supsetpluseq\ams@unimp
\let\varsubsetneqq\ams@unimp
\let\varsubsetneq\ams@unimp
\let\varsupsetneqq\ams@unimp
\let\varsupsetneq\ams@unimp
\let\vartriangle\ams@unimp
\let\doublebarwedge\ams@unimp

\let\ngeqq\ngeq
\let\nleqq\nleq 
\let\ngeqq\ngeq
\let\nleqq\nleq 
\let\ngeqslant\ngeq
\let\nleqslant\nleq

\endinput

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


\def\sideset#1#2#3{\mathop\def\@tempa{#3}%
  \@ifbempty{#1}{\@xsideset{#2}}
      {\@ifbempty{#2}{\@ysideset{#1}}{\@zsideset{#1}{#2}}}\limits}

\def\@xsideset#1{\@scanupdown\@xxsideset\mmlnone\mmlnone{#1}}
\def\@xxsideset#1#2{{\mathbox{mmultiscripts}{\@tempa{#1}{#2}}}}


\def\@ysideset#1{\@scanupdown\@yysideset\mmlnone\mmlnone{#1}}
\def\@yysideset#1#2{{\mathbox{mmultiscripts}{\@tempa\mmlprescripts{#1}{#2}}}}

\def\@zsideset#1#2{\@scanupdown\@zzsideset\mmlnone\mmlnone{#1}{#2}}
\def\@zzsideset#1#2#3{\@scanupdown\@wsideset\mmlnone\mmlnone{#3}{#1}{#2}}
\def\@wsideset#1#2#3#4{{\mathbox{mmultiscripts}
   {\@tempa{#1}{#2}\mmlprescripts{#3}{#4}}}}



