<?xml version="1.0" encoding="UTF-8" ?>
<!-- $Id: get-references.xsl 2679 2010-05-02 17:07:47Z michalr $ -->
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    
    <!-- Nastavení parametrů výstupu. -->
    <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

    <!-- V textu nahradit znaky nového řádku mezerou. -->
    <xsl:template match="text()">
        <xsl:value-of select="translate(.,'&#10;',' ')"/>
    </xsl:template>
    
    <xsl:include href="texmath.xsl"/>
    
    <!-- Sestavení metadat. -->
    <xsl:template match="/">
        
        <xsl:element name="references">
            
            <xsl:for-each select="//Bibliography/p">
                
                <xsl:element name="reference">
                    
                    <xsl:attribute name="id">
                        <xsl:value-of select="position()"/>
                    </xsl:attribute>
                    
                    <xsl:element name="prefix">
                        <xsl:text>[</xsl:text>
                        <xsl:if test="bibitem/@bib-key">
                            <xsl:value-of select="bibitem/@bib-key"/>
                        </xsl:if>
                        <xsl:if test="not(bibitem/@bib-key)">
                            <xsl:value-of select="position()"/>
                        </xsl:if>
                        <xsl:text>]</xsl:text>
                    </xsl:element>
                    
                    <xsl:element name="title">
                        <xsl:apply-templates select="bibtitle"/>
                    </xsl:element>

                    <xsl:element name="authors">
                        <xsl:for-each select="bibauthor">
                            <xsl:element name="author">
                                <xsl:apply-templates select="."/>
                            </xsl:element>
                        </xsl:for-each>
                    </xsl:element>

                    <xsl:if test="bibaddress">
                        <xsl:element name="address">
                            <xsl:apply-templates select="bibaddress"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibbooktitle">
                        <xsl:element name="booktitle">
                            <xsl:apply-templates select="bibbooktitle"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibchapter">
                        <xsl:element name="chapter">
                            <xsl:apply-templates select="bibchapter"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibedition">
                        <xsl:element name="edition">
                            <xsl:apply-templates select="bibedition"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibeditor">
                        <xsl:element name="editors">
                            <xsl:for-each select="bibeditor">
                                <xsl:element name="editor">
                                    <xsl:apply-templates select="."/>
                                </xsl:element>
                            </xsl:for-each>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibhowpublished">
                        <xsl:element name="howpublished">
                            <xsl:apply-templates select="bibhowpublished"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibinstitution">
                        <xsl:element name="institution">
                            <xsl:apply-templates select="bibinstitution"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibISBN">
                        <xsl:element name="ISBN">
                            <xsl:apply-templates select="bibISBN"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibISSN">
                        <xsl:element name="ISSN">
                            <xsl:apply-templates select="bibISSN"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibjournal">
                        <xsl:element name="journal">
                            <xsl:apply-templates select="bibjournal"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibmonth">
                        <xsl:element name="month">
                            <xsl:apply-templates select="bibmonth"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibnote">
                        <xsl:element name="note">
                            <xsl:apply-templates select="bibnote"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibnumber">
                        <xsl:element name="number">
                            <xsl:apply-templates select="bibnumber"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="biborganization">
                        <xsl:element name="organization">
                            <xsl:apply-templates select="biborganization"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibfirstpage or biblastpage">
                        <xsl:element name="pages">
                            <xsl:apply-templates select="bibfirstpage"/>
                            <xsl:text>-</xsl:text>
                            <xsl:apply-templates select="biblastpage"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibpublisher">
                        <xsl:element name="publisher">
                            <xsl:apply-templates select="bibpublisher"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibschool">
                        <xsl:element name="school">
                            <xsl:apply-templates select="bibschool"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibseries">
                        <xsl:element name="series">
                            <xsl:apply-templates select="bibseries"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibtype">
                        <xsl:element name="type">
                            <xsl:apply-templates select="bibtype"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibURL">
                        <xsl:element name="URL">
                            <xsl:apply-templates select="bibURL"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibvolume">
                        <xsl:element name="volume">
                            <xsl:apply-templates select="bibvolume"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:if test="bibyear">
                        <xsl:element name="year">
                            <xsl:apply-templates select="bibyear"/>
                        </xsl:element>
                    </xsl:if>

                    <xsl:element name="suffix">
                        <xsl:apply-templates select="bibtitle/following-sibling::node()"/>
                    </xsl:element>
                    
                </xsl:element>
                
            </xsl:for-each>
            
        </xsl:element>
        
    </xsl:template>
    
</xsl:transform>
