<?xml version="1.0" encoding="UTF-8" ?>
<!-- $Id: get-meta.xsl 2679 2010-05-02 17:07:47Z michalr $ -->
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    
    <!-- Nastavení parametrů výstupu. -->
    <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

    <!-- V textu nahradit znaky nového řádku mezerou. -->
    <xsl:template match="text()">
        <xsl:value-of select="translate(.,'&#10;',' ')"/>
    </xsl:template>

    <xsl:include href="texmath.xsl"/>
    
    <!-- Citační odkazy rozvinout na plný text reference. -->
    <xsl:template match="cit">
        
        <xsl:variable name="item" select="ref/@target"/>

        <xsl:text>[</xsl:text>
        <xsl:apply-templates select="//Bibliography/p[bibitem/@id=$item]"/>
        <xsl:if test="ref/node()">
            <xsl:text>; </xsl:text>
            <xsl:apply-templates select="ref/node()"/>
        </xsl:if>
        <xsl:text>]</xsl:text>
        
    </xsl:template>
    
    <!-- Sestavení metadat. -->
    <xsl:template match="/">
        
        <xsl:element name="article">
            
            <xsl:for-each select="//title">
                <xsl:element name="title">
                    <xsl:attribute name="lang">
                        <xsl:value-of select="@lang"/>
                    </xsl:attribute>
                    <xsl:apply-templates select="."/>
                </xsl:element>
            </xsl:for-each>
            
            <xsl:for-each select="//author">
                <xsl:element name="author">
                    <xsl:attribute name="order">
                        <xsl:value-of select="@order"/>
                    </xsl:attribute>
                    <xsl:apply-templates select="."/>
                </xsl:element>
            </xsl:for-each>
            
            <xsl:element name="language">
                <xsl:apply-templates select="//language"/>
            </xsl:element>
            
            <xsl:for-each select="//keyword">
                <xsl:element name="keyword">
                    <xsl:attribute name="lang">
                        <xsl:value-of select="@lang"/>
                    </xsl:attribute>
                    <xsl:apply-templates select="."/>
                </xsl:element>
            </xsl:for-each>
            
            <xsl:for-each select="//abstract">
                <xsl:element name="summary">
                    <xsl:attribute name="lang">
                        <xsl:value-of select="@lang"/>
                    </xsl:attribute>
                    <xsl:apply-templates select="."/>
                </xsl:element>
            </xsl:for-each>
            
            <xsl:if test="//abstractlanguage">
                <xsl:element name="lang_summary">
                    <xsl:apply-templates select="//abstractlanguage"/>
                </xsl:element>
            </xsl:if>
            
            <xsl:for-each select="//msc">
                <xsl:element name="msc">
                    <xsl:apply-templates select="."/>
                </xsl:element>
            </xsl:for-each>

            <xsl:element name="category">
                <xsl:apply-templates select="//category"/>
            </xsl:element>
            
            <xsl:element name="range_pages">
                <xsl:apply-templates select="//firstpage"/>
                <xsl:text>-</xsl:text>
                <xsl:apply-templates select="//lastpage"/>
            </xsl:element>
            
        </xsl:element>
        
    </xsl:template>
        
</xsl:transform>
